use GPW;
GO

/*
insert into dbo.spolki2 values(1,'KGHM', 'KGH'), (2,'TPSA','TPS'), (3,'INGBSK', 'ING');
GO
*/

/*
BULK INSERT dbo.notowania2
FROM 'C:\Users\Administrator\Desktop\kghm_tpsa_ing_dotted.csv'
WITH
(
FIELDTERMINATOR = ';',
ROWTERMINATOR = '\n'
)
GO
*/

--select top 50 * from dbo.notowania2;

-- jak skladana jest srednia kroczaca
/*
SELECT x.Row as xrow, y.Row as yrow, x.id as xid, y.id as yid, x.data as xdata, y.data as ydata, y.wolumen
FROM
(SELECT ROW_NUMBER() OVER (ORDER BY data asc) AS Row, id, data, spolki_id FROM dbo.notowania2 where spolki_id = 2) AS x,
(SELECT ROW_NUMBER() OVER (ORDER BY data asc) AS Row, id, data, wolumen, spolki_id FROM dbo.notowania2 where spolki_id = 2 ) AS y
WHERE x.Row between y.Row and y.Row+9
ORDER BY x.data asc
*/

-- srednia kroczaca
/*
SELECT x.data as xdata, AVG(y.wolumen)
FROM
(SELECT ROW_NUMBER() OVER (ORDER BY data ASC) AS Row, data FROM dbo.notowania2 where spolki_id = 2) AS x,
(SELECT ROW_NUMBER() OVER (ORDER BY data ASC) AS Row, data, wolumen FROM dbo.notowania2 where spolki_id = 2 ) AS y
WHERE x.Row between y.Row AND y.Row+9
GROUP BY x.data
ORDER BY x.data ASC
go
*/


-- suma po miesiacach
/*
select CAST(data as CHAR(7)) as data, SUM(wolumen) as wolumen_suma
from dbo.notowania2
where spolki_id = 2 and data between '2009-01-01' and '2009-12-31'
group by CAST(data as CHAR(7))
order by data asc
*/

-- srednia geometryczna
/*
select CAST(data as CHAR(7)) as data, SUM(wolumen) as wolumen_suma, dbo.AVGGeo(wolumen) as avggeo, dbo.AVGHarm(wolumen) as avgharm
from dbo.notowania2
where spolki_id = 2 and data between '2009-01-01' and '2009-12-31'
group by CAST(data as CHAR(7))
order by data asc
*/


-- zarejestrowanie assembly i agregatow
exec sp_configure 'clr enabled', 1
go

RECONFIGURE WITH OVERRIDE
go

IF EXISTS (SELECT name FROM sysobjects WHERE name = 'AVGWeighted')
   DROP AGGREGATE AVGWeighted
IF EXISTS (SELECT name FROM sysobjects WHERE name = 'AVGHarm')
   DROP AGGREGATE AVGHarm
IF EXISTS (SELECT name FROM sysobjects WHERE name = 'AVGGeo')
   DROP AGGREGATE AVGGeo
go

IF EXISTS (SELECT name FROM sys.assemblies WHERE name = 'MyAggregates')
   DROP ASSEMBLY MyAggregates
go

CREATE ASSEMBLY MyAggregates FROM 'C:\Users\Administrator\Documents\hello\SqlServerProject8\AVGGeo\obj\Debug\SqlClassLibrary.dll'
GO

CREATE AGGREGATE AVGGeo (@value float) RETURNS float
EXTERNAL NAME MyAggregates.AVGGeo
CREATE AGGREGATE AVGHarm (@value float) RETURNS float
EXTERNAL NAME MyAggregates.AVGHarm
CREATE AGGREGATE AVGWeighted (@value float, @weight float) RETURNS float
EXTERNAL NAME MyAggregates.AVGWeighted
go


-- srednia wazona
select CAST(data as CHAR(7)) as data, dbo.AVGWeighted(zamnk, zmiana) as avgweight
from dbo.notowania2
where spolki_id = 2 and data between '2009-01-01' and '2009-12-31'
group by CAST(data as CHAR(7))
order by data asc



-- tabela do sprawdzenia sredniej wazonej
/*
IF EXISTS (SELECT name FROM systypes WHERE name = 'MyTableType')
   DROP TYPE MyTableType
go

CREATE TYPE MyTableType AS table (ItemValue decimal(10,3), ItemWeight decimal(10,3))
go

DECLARE @myTable AS MyTableType

INSERT INTO @myTable VALUES(1.0, 50.0)
INSERT INTO @myTable VALUES(6.0, 1.0)
INSERT INTO @myTable VALUES(5.0, -1.0)
INSERT INTO @myTable VALUES(6.0, -2.0)
INSERT INTO @myTable VALUES(6.0, -10.0)

SELECT dbo.AVGWeighted(ItemValue, ItemWeight) FROM @myTable
go
*/

-- rednie kroczce: prosta, geometryczna, harmoniczna z ostatnich 10 prbek, dla akcji TPSA w 2009 roku
SELECT x.data AS xdata, AVG(y.wolumen) AS vol, dbo.AVGGeo(y.wolumen) AS avggeo, dbo.AVGHarm(y.wolumen) AS avgharm
FROM
(SELECT ROW_NUMBER() OVER (ORDER BY data ASC) AS Row, data FROM dbo.notowania2 WHERE spolki_id = 2) AS x,
(SELECT ROW_NUMBER() OVER (ORDER BY data ASC) AS Row, data, wolumen FROM dbo.notowania2 WHERE spolki_id = 2 ) AS y
WHERE x.data BETWEEN '2009-01-01' AND '2009-12-31' AND x.Row between y.Row AND y.Row+9
GROUP BY x.data
ORDER BY x.data ASC
