﻿using System;
using System.Data;
using System.Data.SqlClient;
using System.Data.SqlTypes;
using Microsoft.SqlServer.Server;

[Serializable]
[Microsoft.SqlServer.Server.SqlUserDefinedAggregate(
	Format.Native,
	IsInvariantToDuplicates = false,
	IsInvariantToNulls = true,
	IsInvariantToOrder = true,
	IsNullIfEmpty = true)]
public struct AVGWeighted
{
	private double suma;
	private double ilosc;

	public void Init()
	{
		this.suma = 0;
		this.ilosc = 0;
	}

	public void Accumulate(SqlDouble Value, SqlDouble Weight)
	{
		if (!Value.IsNull && !Weight.IsNull)
		{
			this.suma += (double)Value * (double)Weight;
			this.ilosc += (double)Weight;
		}
	}

	public void Merge(AVGWeighted Group)
	{
		this.suma += Group.suma;
		this.ilosc += Group.ilosc;
	}

	public SqlDouble Terminate()
	{
		if (this.ilosc != 0)
		{
			return new SqlDouble(this.suma / this.ilosc);
		}
		else
		{
			return SqlDouble.Null;
		}
	}

}
