﻿using System;
using System.Data;
using System.Data.SqlClient;
using System.Data.SqlTypes;
using Microsoft.SqlServer.Server;


[Serializable]
[Microsoft.SqlServer.Server.SqlUserDefinedAggregate(
	Format.Native,
	IsInvariantToDuplicates = false,
	IsInvariantToNulls = true,
	IsInvariantToOrder = true,
	IsNullIfEmpty = true)]
public struct AVGHarm
{
	private double suma;
	private long ilosc;

	public void Init()
	{
		this.suma = 0;
		this.ilosc = 0;
	}

	public void Accumulate(SqlDouble Value)
	{
		if (!Value.IsNull)
		{
			this.suma += 1/(double)Value;
			this.ilosc++;
		}
	}

	public void Merge(AVGHarm Group)
	{
		this.suma += Group.suma;
		this.ilosc += Group.ilosc;
	}

	public SqlDouble Terminate()
	{
		if (this.ilosc > 0)
		{
			return new SqlDouble(this.ilosc / this.suma);
		}
		else
		{
			return SqlDouble.Null;
		}
	}

}
