﻿using System;
using System.Data;
using System.Data.SqlClient;
using System.Data.SqlTypes;
using Microsoft.SqlServer.Server;


[Serializable]
[Microsoft.SqlServer.Server.SqlUserDefinedAggregate(
	Format.Native,
	IsInvariantToDuplicates = false,
	IsInvariantToNulls = true,
	IsInvariantToOrder = true,
	IsNullIfEmpty = true)]
public struct AVGGeo
{

	// This is a place-holder member field
	private double iloczyn;
	private long ilosc;

    public void Init()
    {
		this.iloczyn = 1;
		this.ilosc = 0;
    }

    public void Accumulate(SqlDouble Value)
    {
		if(!Value.IsNull)
		{
			this.iloczyn *= (double)Value;
			this.ilosc++;
		}
    }

    public void Merge(AVGGeo Group)
    {
		this.iloczyn *= Group.iloczyn;
		this.ilosc += Group.ilosc;
    }

    public SqlDouble Terminate()
    {
		if (this.ilosc > 0)
		{
			return new SqlDouble(Math.Pow(this.iloczyn, 1.0/this.ilosc));
		}
		else
		{
			return SqlDouble.Null;
		}
	
    }

}
