#include<stdio.h>
#include<malloc.h>
#include"bst.h"

// wyswietla key z podanego wskaznika
void echo(BST *root){
	if(root != NULL) printf("%d\n",root->key);
	else printf("brak\n");
	return ;
}

// wypisuje drzewo w porzadku inoder (posortowane rosnaco)
void inorder(BST *root){
	if(root != NULL){
		inorder(root->left);
		printf("%d ",root->key);
		inorder(root->right);
	}
	return ;
}

// wypisywanie drzewa w porzadku preorder
void preorder(BST *root){
	if(root != NULL){
		printf("%d ",root->key);
		preorder(root->left);
		preorder(root->right);
	}
	return ;
}

// wypisywanie drzewa w porzadku postorder
void postorder(BST *root){
	if(root != NULL){
		postorder(root->left);
		postorder(root->right);
		printf("%d ",root->key);
	}
	return ;
}

// wypisywanie drzewa w porzadku odwrotnym do postorder
void postorderinverse(BST *root){
	if(root != NULL){
		printf("%d ",root->key);
		postorderinverse(root->right);
		postorderinverse(root->left);
	}
	return ;
}

// szukanie rekurencyjne
BST *search(BST *root, int val){
	if((root == NULL) || (val == root->key)) return root;
	if(val < root->key){
		return search(root->left,val);
	}
	else {
		return search(root->right,val);
	}
	return root;
}

// przeszukiwanie iteracyjne (efektywniejsze)
BST *isearch(BST *root,int val){
	while((root != NULL) && (val != root->key)){
		if(val < root->key) root = root->left;
		else root = root->right;
	}
	return root;
}

// znajdowanie minimum
BST *min(BST *root){
	while(root->left != NULL){
		root = root->left;
	}
	return root;
}

// znajdowanie maksimum
BST *max(BST *root){
	while(root->right != NULL){
		root = root->right;
	}
	return root;
}

//wskazywanie drogi pomiedzy dwoma elementami
void trace(BST *root, int v1, int v2){
	BST* x = isearch(root,v1);
	BST* y = isearch(root,v2);

	if(v1 > v2){
		int tmp=v2;
		v2=v1;
		v1=tmp;
	}
	//printf("\tkey:%d\n",root->key);
	if(root==NULL || x==NULL || y==NULL){
		printf("brak drogi");
	}
	else{
		if(v1<root->key && v2 < root->key){
			trace(root->left,v1,v2);
		}
		if(v1>root->key && v2 > root->key){
			trace(root->right,v1,v2);
		}
		if(v1<=root->key && v2 >= root->key){
			while(x != root){
				printf("%d ",x->key);
				x=x->p;
			}
			printf("%d ",x->key);
			while(root != y){
				if(y->key < root->key){
					root = root->left;
					printf("%d ",root->key);
				}
				if(y->key > root->key){
					root = root->right;
					printf("%d ",root->key);
				}
			}
		}
	}
}

// rysuje drzewo
void draw(BST* root){
	if(root != NULL){
		printf("%-3d", root->key);
		if(root->left == NULL && root->right == NULL);
		else{
			printf("(");
			if(root->left != NULL) printf("%-3d,", root->left->key); else printf(".  ,");
			if(root->right != NULL) printf("%3d", root->right->key); else printf("  .");
			printf(")");
		}
		printf("\n");
	}
	if(root->left !=NULL) draw(root->left);
	if(root->right !=NULL) draw(root->right);
}

//successor
BST *nastepnik(BST *root){
	BST* y = root;
	
	//exception
	if(root==NULL) return y;
	
	if(root->right != NULL){
		return min(root->right);
	}
	y = root->p;
	while(y != NULL && root == y->right){
		root = y;
		y = y->p;
	}
	return y;
}

//predecessor
BST *poprzednik(BST *root){
	BST* y = root;
	
	//exception
	if(root==NULL) return y;

	if(root->left != NULL){
		return max(root->left);
	}
	y = root->p;
	while(y!=NULL && root == y->left){
		root = y;
		y = y->p;
	}
	return y;
}

//usuwanie
BST *del(BST *root, int val){
	// wskazniki pomocnicze
	BST* x = root;
	BST* y = (BST*)malloc(sizeof(BST));
	// to co usuwamy
	BST* del = search(root,val);

	if(del == NULL) return y;

	if(del->left==NULL || del->right==NULL) y=del;
	else y=nastepnik(del);
	
	if(y->left!=NULL) x=y->left;
	else x=y->right;
	
	if(x!=NULL) x->p = y->p;
	
	if(y->p == NULL) root = x;
	else if(y == y->p->left) y->p->left = x;
	else y->p->right = x;
	
	if(y!=del){
		del->key = y->key;
	}
	return y;
}

// dodawanie
BST *add(BST *root, int val){
	BST *x = root;
	
	// nowy obiekt, ktory wpinany jest do drzewa
	BST *nowe = (BST *)malloc(sizeof(BST));
	nowe->key = val;
	nowe->p = nowe->left = nowe->right = NULL;

	BST *y = NULL;
	while(x != NULL){
		y = x;
		if(val < x->key) x = x->left;
		else x = x->right;
	}
	nowe->p = y;
	if(y == NULL) root = nowe;
	else {
		if(nowe->key < y->key) y->left = nowe;
		else y->right = nowe;
	}
	return root;
}

// oblicza ilosc wezlow w drzewie
int waga(BST *root){
	if(root == NULL) return 0;
	else return waga(root->left) + waga(root->right) + 1;
}
